/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.PIDataBeanInterface;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.client.SRCEntry;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.PIHscUtil;
import java.util.Hashtable;
import java.util.Locale;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class PILPARDataBean
implements PIDataBeanInterface {
    public static final String PARTITION_ID = "lpar_id";
    public static final String PARTITION_ID_PROP = "partitionID_PROP";
    public static final String NAME = "name";
    public static final String USER_DEFINED_NAME = "lpar_name";
    public static final String NEW_NAME = "new_name";
    public static final String DEFINITION_STATE = "resource_config";
    public static final String CLUSTER_ID = "work_group_id";
    public static final String HOSTING_PARTITIONS = "power_ctrl_lpar_ids";
    public static final String HOSTING_PARTITION_NAMES = "power_ctrl_lpar_names";
    public static final String LOGICAL_SERIAL = "logical_serial_num";
    public static final String OS_VERSION = "os_version";
    public static final String FUNCTIONAL_CONFIG = "functional_config";
    public static final String CIM_OBJ_PATH = "cimObjectPath_PROP";
    public static final String PARTITION_ENVIRONMENT = "lpar_env";
    public static final String PARTITION_TYPE = "lpar_type";
    public static final String PARTITION_TYPE_PROP = "partitionType_PROP";
    public static final String STATE = "state";
    public static final String PARTITION_STATE_PROP = "state_PROP";
    public static final String BOOT_MODE = "boot_mode";
    public static final String BOOT_MODE_PROP = "bootMode_PROP";
    public static final String OP_PANEL_WIN_COUNT = "op_panel_window_count";
    public static final String OP_PANEL_WIN_COUNT_PROP = "opPanelWindowCount_PROP";
    public static final String OP_PANEL_VALUE = "op_panel_value";
    public static final String OP_PANEL_VALUE_PROP = "opPanelValue_PROP";
    public static final String DLPAR_CAPABILITIES = "dlpar_capabilities";
    public static final String DLPAR_CAPABILITIES_PROP = "dlparCapabilities_PROP";
    public static final String CIM_OBJ_PATH_PROP = "cimObjectPath_PROP";
    public static final String IPL_SOURCE = "ipl_source";
    public static final String POWER_ON_WITH_HYP = "auto_start";
    public static final String TCP_INFO = "tcp_ip_info";
    public static final String SERVICE_AUTHORITY = "service_authority";
    public static final String ACTIVE_PROFILE = "curr_profile";
    public static final String ACTIVE_PROFILE_PROP = "activatedProfile_PROP";
    public static final String DEFAULT_PROFILE = "default_profile";
    public static final String SRC = "src";
    public static final String SHARED_POOL_UTILIZATION_AUTHORITY = "shared_proc_pool_util_auth";
    public static final String VIRTUAL_PANEL_FUNCTIONS = "VirtualPanelFunctions";
    public static final String SYS_CMD_CAPABILITIES = "SysCmdCapabilities";
    public static final String CUR_SHARED_POOL_ID = "curr_shared_proc_pool_id";
    public static final String CUR_PROC_TYPE = "curr_proc_mode";
    public static final String CUR_SHARING_MODE = "curr_sharing_mode";
    public static final String CUR_UNCAPPED_WEIGHT = "curr_uncap_weight";
    public static final String CUR_MIN_PROCS = "curr_min_procs";
    public static final String CUR_ALLOC_PROCS = "curr_procs";
    public static final String CUR_MAX_PROCS = "curr_max_procs";
    public static final String CUR_MIN_PROC_UNITS = "curr_min_proc_units";
    public static final String CUR_ALLOC_PROC_UNITS = "curr_proc_units";
    public static final String CUR_MAX_PROC_UNITS = "curr_max_proc_units";
    public static final String PEND_SHARED_POOL_ID = "pend_shared_proc_pool_id";
    public static final String PEND_PROC_TYPE = "pend_proc_mode";
    public static final String PEND_SHARING_MODE = "pend_sharing_mode";
    public static final String PEND_UNCAPPED_WEIGHT = "pend_uncap_weight";
    public static final String PEND_MIN_PROCS = "pend_min_procs";
    public static final String PEND_ALLOC_PROCS = "pend_procs";
    public static final String PEND_MAX_PROCS = "pend_max_procs";
    public static final String PEND_MIN_PROC_UNITS = "pend_min_proc_units";
    public static final String PEND_ALLOC_PROC_UNITS = "pend_proc_units";
    public static final String PEND_MAX_PROC_UNITS = "pend_max_proc_units";
    public static final String RUNTIME_PROC_TYPE = "runtime_proc_mode";
    public static final String RUNTIME_SHARING_MODE = "runtime_sharing_mode";
    public static final String RUNTIME_UNCAPPED_WEIGHT = "run_uncap_weight";
    public static final String RUNTIME_PROCS = "run_procs";
    public static final String RUNTIME_PROC_UNITS = "run_proc_units";
    public static final String CUR_MIN_MEM = "curr_min_mem";
    public static final String CUR_ALLOC_MEM = "curr_mem";
    public static final String CUR_MAX_MEM = "curr_max_mem";
    public static final String PEND_MIN_MEM = "pend_min_mem";
    public static final String PEND_ALLOC_MEM = "pend_mem";
    public static final String PEND_MAX_MEM = "pend_max_mem";
    public static final String RUNTIME_MEM = "run_mem";
    public static final String RUNTIME_MIN_MEM = "run_min_mem";
    public static final String REQ_MIN_MAX = "req_min_for_max";
    public static final String MM_CURR_RESERVE1_MIN_MEM = "mm_curr_reserve1_min_mem";
    public static final String MM_CURR_RESERVE1_MEM = "mm_curr_reserve1_mem";
    public static final String MM_CURR_RESERVE1_MAX_MEM = "mm_curr_reserve1_max_mem";
    public static final String MM_PEND_RESERVE1_MIN_MEM = "mm_pend_reserve1_min_mem";
    public static final String MM_PEND_RESERVE1_MEM = "mm_pend_reserve1_mem";
    public static final String MM_PEND_RESERVE1_MAX_MEM = "mm_pend_reserve1_max_mem";
    public static final String MM_CURR_RESERVE2_MIN_MEM = "mm_curr_reserve2_min_mem";
    public static final String MM_CURR_RESERVE2_MEM = "mm_curr_reserve2_mem";
    public static final String MM_CURR_RESERVE2_MAX_MEM = "mm_curr_reserve2_max_mem";
    public static final String MM_PEND_RESERVE2_MIN_MEM = "mm_pend_reserve2_min_mem";
    public static final String MM_PEND_RESERVE2_MEM = "mm_pend_reserve2_mem";
    public static final String MM_PEND_RESERVE2_MAX_MEM = "mm_pend_reserve2_max_mem";
    public static final String CUR_MIN_INT_PERF = "curr_min_5250_cpw_percent";
    public static final String CUR_ALLOC_INT_PERF = "curr_5250_cpw_percent";
    public static final String CUR_MAX_INT_PERF = "curr_max_5250_cpw_percent";
    public static final String PEND_MIN_INT_PERF = "pend_min_5250_cpw_percent";
    public static final String PEND_ALLOC_INT_PERF = "pend_5250_cpw_percent";
    public static final String PEND_MAX_INT_PERF = "pend_max_5250_cpw_percent";
    public static final String RUNTIME_INT_PERF = "run_5250_cpw_percent";
    public static final String VALID_INT_PERF_MIN = "valid_interactive_perf_min";
    public static final String VALID_INT_PERF_MAX = "valid_interactive_perf_max";
    public static final String VIRTUAL_OPTICONNECT = "virtual_opticonnect";
    public static final String HSL_OPTICONNECT = "hsl_opticonnect";
    public static final String LOADSOURCE_INDEX = "loadsource_index";
    public static final String ALT_LOADSOURCE_INDEX = "alt_loadsource_index";
    public static final String OLD_ALT_LOADSOURCE_INDEX = "old_alt_loadsource_index";
    public static final String CONSOLE_INDEX = "console_index";
    public static final String ALT_CONSOLE_INDEX = "alt_console_index";
    public static final String ECS_INDEX = "ecs_index";
    public static final String TAGGED_IO_INFO = "tagged_io_info";
    public static final String IO_INFO = "io_info";
    public static final String IO_INFO_PROP = "resourcesInfo_PROP";
    public static final String SMA_INFO = "sma_info";
    public static final String SMA_INFO_PROP = "smaInfo_PROP";
    public static final String VIRTUAL_SERVICE_LED = "virtual_service_led";
    public static final String CUR_MAX_VIRTUAL_IO = "curr_max_virtual_slots";
    public static final String PEND_MAX_VIRTUAL_IO = "pend_max_virtual_slots";
    public static final String RMC_ACTIVE = "rmc_active";
    public static final String LPAR_KEYLOCK = "lpar_keylock";
    public static final String SFP_SURVEILLANCE = "conn_monitoring";
    public static final String SNI_DEVICE_IDS = "sni_device_ids";
    public static final String SNI_WINDOWS = "sni_windows";
    public static final String SNI_CONFIG_MODE = "sni_config_mode";
    public static final UnsignedInt8 OS400_VALID = new UnsignedInt8(130);
    public static final UnsignedInt8 OS400_NOT_BOOTABLE = new UnsignedInt8(129);
    public static final UnsignedInt8 RPA_VALID = new UnsignedInt8(2);
    public static final UnsignedInt8 RPA_NOT_BOOTABLE = new UnsignedInt8(1);
    public static final UnsignedInt8 RPA_IO_SERVER_VALID = new UnsignedInt8(4);
    public static final UnsignedInt8 RPA_IO_SERVER_NOT_BOOTABLE = new UnsignedInt8(3);
    public static final UnsignedInt8 MEGAMOUTH_NOT_BOOTABLE = new UnsignedInt8(65);
    public static final UnsignedInt8 MEGAMOUTH_VALID = new UnsignedInt8(66);
    public static final short OS400_TYPE = 128;
    public static final short RPA_TYPE = 0;
    public static final int MAX_CLUSTER_ID = Short.MAX_VALUE;
    public static final String STRING_NO_CLUSTER = "none";
    public static final String STRING_RPA = "aixlinux";
    public static final String STRING_OS400 = "os400";
    public static final String STRING_MM_RPA = "ess";
    public static final String STRING_VIOSERVER = "vioserver";
    public static final String[] ALL_KEYS = new String[]{"lpar_id", "lpar_name", "resource_config", "state", "op_panel_window_count", "src", "VirtualPanelFunctions", "dlpar_capabilities", "cimObjectPath_PROP", "ipl_source", "auto_start", "tcp_ip_info", "boot_mode", "service_authority", "curr_profile", "work_group_id", "power_ctrl_lpar_ids", "power_ctrl_lpar_names", "logical_serial_num", "lpar_keylock", "os_version", "functional_config", "lpar_type", "curr_shared_proc_pool_id", "curr_proc_mode", "curr_sharing_mode", "curr_uncap_weight", "curr_min_procs", "curr_procs", "curr_max_procs", "curr_min_proc_units", "curr_proc_units", "curr_max_proc_units", "pend_shared_proc_pool_id", "pend_proc_mode", "pend_sharing_mode", "pend_uncap_weight", "pend_min_procs", "pend_procs", "pend_max_procs", "pend_min_proc_units", "pend_proc_units", "pend_max_proc_units", "runtime_proc_mode", "runtime_sharing_mode", "run_uncap_weight", "run_procs", "run_proc_units", "curr_min_mem", "curr_mem", "curr_max_mem", "pend_min_mem", "pend_mem", "pend_max_mem", "run_mem", "run_min_mem", "curr_min_5250_cpw_percent", "curr_5250_cpw_percent", "curr_max_5250_cpw_percent", "req_min_for_max", "pend_min_5250_cpw_percent", "pend_5250_cpw_percent", "pend_max_5250_cpw_percent", "run_5250_cpw_percent", "valid_interactive_perf_min", "valid_interactive_perf_max", "virtual_service_led", "io_info", "sma_info", "curr_max_virtual_slots", "pend_max_virtual_slots", "virtual_opticonnect", "hsl_opticonnect", "loadsource_index", "alt_loadsource_index", "old_alt_loadsource_index", "console_index", "alt_console_index", "ecs_index", "SysCmdCapabilities", "shared_proc_pool_util_auth"};
    public String m_internalName;
    private String m_userDefinedName;
    private UnsignedInt8 m_definitionState;
    private UnsignedInt16 m_clusterID;
    private UnsignedInt16[] m_hostingPartitions;
    private String[][] m_hostingPartitionNames;
    public String m_logicalSerial;
    public UnsignedInt8[] m_suppVirtualpanelFuncs;
    public UnsignedInt32 m_sysCmdCapabilities;
    public String m_OSVersion;
    public UnsignedInt8 m_functionalConfig;
    public String m_partitionType;
    public UnsignedInt8 m_partitionState;
    public UnsignedInt8 m_partitionBootMode;
    public UnsignedInt32 m_dlparCapabilities;
    public CIMObjectPath m_cimObjPath;
    public UnsignedInt8 m_iplSource;
    public UnsignedInt8 m_powerWithHyp;
    private String m_tcpIpInfo;
    public Boolean m_serviceAuthority;
    public UnsignedInt8 m_opPanelWinCount;
    public String m_activeProfile;
    private String m_defaultProfile;
    public String m_opPanelValue;
    public SRCEntry m_src;
    public UnsignedInt8 m_sharedPoolUtilizationAuthority;
    public UnsignedInt8 m_lparKeylock;
    public UnsignedInt8 m_curProcType;
    public UnsignedInt8 m_curSharingMode;
    public UnsignedInt16 m_curUncappedWeight;
    public UnsignedInt16 m_curMinProcs;
    public UnsignedInt16 m_curAllocProcs;
    public UnsignedInt16 m_curMaxProcs;
    public UnsignedInt32 m_curMinProcUnits;
    public UnsignedInt32 m_curAllocProcUnits;
    public UnsignedInt32 m_curMaxProcUnits;
    private UnsignedInt8 m_pendProcType;
    private UnsignedInt8 m_pendSharingMode;
    private UnsignedInt16 m_pendUncappedWeight;
    private UnsignedInt16 m_pendMinProcs;
    private UnsignedInt16 m_pendAllocProcs;
    private UnsignedInt16 m_pendMaxProcs;
    private UnsignedInt32 m_pendMinProcUnits;
    private UnsignedInt32 m_pendAllocProcUnits;
    private UnsignedInt32 m_pendMaxProcUnits;
    private UnsignedInt8 m_runtimeProcType;
    private UnsignedInt8 m_runtimeSharingMode;
    private UnsignedInt16 m_runtimeUncappedWeight;
    private UnsignedInt16 m_runtimeProcs;
    private UnsignedInt32 m_runtimeProcUnits;
    public UnsignedInt32 m_curMinMem;
    public UnsignedInt32 m_curAllocMem;
    public UnsignedInt32 m_curMaxMem;
    private UnsignedInt32 m_pendMinMem;
    private UnsignedInt32 m_pendAllocMem;
    private UnsignedInt32 m_pendMaxMem;
    private UnsignedInt32 m_runtimeMem;
    public UnsignedInt32 m_runtimeMinMem;
    public UnsignedInt32 m_reqMinForMax;
    public UnsignedInt32 m_mmCurrReserve1MinMem;
    public UnsignedInt32 m_mmCurrReserve1Mem;
    public UnsignedInt32 m_mmCurrReserve1MaxMem;
    public UnsignedInt32 m_mmPendReserve1MinMem;
    public UnsignedInt32 m_mmPendReserve1Mem;
    public UnsignedInt32 m_mmPendReserve1MaxMem;
    public UnsignedInt32 m_mmCurrReserve2MinMem;
    public UnsignedInt32 m_mmCurrReserve2Mem;
    public UnsignedInt32 m_mmCurrReserve2MaxMem;
    public UnsignedInt32 m_mmPendReserve2MinMem;
    public UnsignedInt32 m_mmPendReserve2Mem;
    public UnsignedInt32 m_mmPendReserve2MaxMem;
    public UnsignedInt16 m_curMinIntPerf;
    public UnsignedInt16 m_curAllocIntPerf;
    public UnsignedInt16 m_curMaxIntPerf;
    private UnsignedInt16 m_pendMinIntPerf;
    private UnsignedInt16 m_pendAllocIntPerf;
    private UnsignedInt16 m_pendMaxIntPerf;
    private UnsignedInt16 m_runtimeIntPerf;
    public UnsignedInt16 m_validIntPerfMin;
    public UnsignedInt16 m_validIntPerfMax;
    private UnsignedInt8 m_virtualOptiConnect;
    private UnsignedInt8 m_hslOptiConnect;
    public UnsignedInt32 m_loadSourceDRCIndex;
    public UnsignedInt32 m_altLoadSourceDRCIndex;
    public UnsignedInt32 m_oldAltLoadSourceDRCIndex;
    public UnsignedInt32 m_consoleDRCIndex;
    public UnsignedInt32 m_altConsoleDRCIndex;
    public UnsignedInt32 m_ecsDRCIndex;
    private Boolean[] m_taggedIOInfo;
    public UnsignedInt8 m_virtualServiceLed;
    public UnsignedInt16 m_curMaxVirtualIO;
    private UnsignedInt16 m_pendMaxVirtualIO;
    public Hashtable m_ioInfo;
    public Hashtable m_smaInfo;

    public String[] getAllKeys() {
        return ALL_KEYS;
    }

    public String getInternalName() {
        return this.m_internalName;
    }

    public UnsignedInt16 getLparID() {
        if (this.m_internalName == null) {
            return null;
        }
        return new UnsignedInt16(this.m_internalName.substring(0, this.m_internalName.indexOf("*")));
    }

    public String getUserDefinedName() {
        return this.m_userDefinedName;
    }

    public void setUserDefinedName(String string) {
        this.m_userDefinedName = string;
    }

    public UnsignedInt8 getDefinitionState() {
        return this.m_definitionState;
    }

    public void setDefinitionState(UnsignedInt8 unsignedInt8) {
        this.m_definitionState = unsignedInt8;
    }

    public boolean isOS400() {
        return this.m_definitionState != null && (this.m_definitionState.shortValue() & 0x80) == 128;
    }

    public boolean isRPA() {
        return this.m_definitionState != null && (this.m_definitionState.shortValue() & 0x80) == 0;
    }

    public boolean isRPAIOServer() {
        return this.isRPA() && (this.m_definitionState.shortValue() == RPA_IO_SERVER_VALID.shortValue() || this.m_definitionState.shortValue() == RPA_IO_SERVER_NOT_BOOTABLE.shortValue());
    }

    public CIMObjectPath getCimObject() {
        return this.m_cimObjPath;
    }

    public UnsignedInt16 getClusterID() {
        return this.m_clusterID;
    }

    public void setClusterID(UnsignedInt16 unsignedInt16) {
        this.m_clusterID = unsignedInt16;
    }

    public UnsignedInt8 getSharedPoolUtilizationAuthority() {
        return this.m_sharedPoolUtilizationAuthority;
    }

    public void setSharedPoolUtilizationAuthority(UnsignedInt8 unsignedInt8) {
        this.m_sharedPoolUtilizationAuthority = unsignedInt8;
    }

    public UnsignedInt16[] getHostingPartitions() {
        return this.m_hostingPartitions;
    }

    public String[][] getHostingPartitionNames() {
        return this.m_hostingPartitionNames;
    }

    public void setHostingPartitions(UnsignedInt16[] unsignedInt16Array) {
        this.m_hostingPartitions = unsignedInt16Array;
    }

    public void setHostingPartitionNames(String[][] stringArray) {
        this.m_hostingPartitionNames = stringArray;
    }

    public String getLogicalSerial() {
        return this.m_logicalSerial;
    }

    public String getOSVersion() {
        return this.m_OSVersion;
    }

    public UnsignedInt8 getFunctionalConfig() {
        return this.m_functionalConfig;
    }

    public String getPartitionType() {
        return this.m_partitionType;
    }

    public void setPartitionType(String string) {
        this.m_partitionType = string;
    }

    public UnsignedInt8 getState() {
        return this.m_partitionState;
    }

    public UnsignedInt8 getBootMode() {
        return this.m_partitionBootMode;
    }

    public UnsignedInt32 getDlparCapabilities() {
        return this.m_dlparCapabilities;
    }

    public String getTcpIpInfo() {
        return this.m_tcpIpInfo;
    }

    public void setTcpIpInfo(String string) {
        this.m_tcpIpInfo = string;
    }

    public UnsignedInt8 getOpPanelWindowCount() {
        return this.m_opPanelWinCount;
    }

    public String getOpPanelValue() {
        return this.m_opPanelValue;
    }

    public SRCEntry getSrc() {
        return this.m_src;
    }

    public String getActiveProfile() {
        return this.m_activeProfile;
    }

    public void setActiveProfile(String string) {
        this.m_activeProfile = string;
    }

    public String getDefaultProfile() {
        return this.m_defaultProfile;
    }

    public void setDefaultProfile(String string) {
        this.m_defaultProfile = string;
    }

    public UnsignedInt8 getIplSource() {
        return this.m_iplSource;
    }

    public void setIplSource(UnsignedInt8 unsignedInt8) {
        this.m_iplSource = unsignedInt8;
    }

    public UnsignedInt8 getPowerOnWithHyp() {
        return this.m_powerWithHyp;
    }

    public UnsignedInt8 getKeylock() {
        return this.m_lparKeylock;
    }

    public void setKeylock(UnsignedInt8 unsignedInt8) {
        this.m_lparKeylock = unsignedInt8;
    }

    public UnsignedInt8 getCurProcType() {
        return this.m_curProcType;
    }

    public boolean isProcModeShared() {
        return this.m_curProcType != null && this.m_curProcType.intValue() != 255;
    }

    public UnsignedInt8 getCurSharingMode() {
        return this.m_curSharingMode;
    }

    public UnsignedInt16 getCurUncappedWeight() {
        return this.m_curUncappedWeight;
    }

    public UnsignedInt16 getCurMinProcs() {
        return this.m_curMinProcs;
    }

    public UnsignedInt16 getCurAllocProcs() {
        return this.m_curAllocProcs;
    }

    public UnsignedInt16 getCurMaxProcs() {
        return this.m_curMaxProcs;
    }

    public UnsignedInt32 getCurMinProcUnits() {
        return this.m_curMinProcUnits;
    }

    public UnsignedInt32 getCurAllocProcUnits() {
        return this.m_curAllocProcUnits;
    }

    public UnsignedInt32 getCurMaxProcUnits() {
        return this.m_curMaxProcUnits;
    }

    public UnsignedInt8 getPendProcType() {
        return this.m_pendProcType;
    }

    public void setPendProcType(UnsignedInt8 unsignedInt8) {
        this.m_pendProcType = unsignedInt8;
    }

    public UnsignedInt8 getPendSharingMode() {
        return this.m_pendSharingMode;
    }

    public void setPendSharingMode(UnsignedInt8 unsignedInt8) {
        this.m_pendSharingMode = unsignedInt8;
    }

    public UnsignedInt16 getPendUncappedWeight() {
        return this.m_pendUncappedWeight;
    }

    public void setPendUncappedWeight(UnsignedInt16 unsignedInt16) {
        this.m_pendUncappedWeight = unsignedInt16;
    }

    public UnsignedInt16 getPendMinProcs() {
        return this.m_pendMinProcs;
    }

    public void setPendMinProcs(UnsignedInt16 unsignedInt16) {
        this.m_pendMinProcs = unsignedInt16;
    }

    public UnsignedInt16 getPendAllocProcs() {
        return this.m_pendAllocProcs;
    }

    public void setPendAllocProcs(UnsignedInt16 unsignedInt16) {
        this.m_pendAllocProcs = unsignedInt16;
    }

    public UnsignedInt16 getPendMaxProcs() {
        return this.m_pendMaxProcs;
    }

    public void setPendMaxProcs(UnsignedInt16 unsignedInt16) {
        this.m_pendMaxProcs = unsignedInt16;
    }

    public UnsignedInt32 getPendMinProcUnits() {
        return this.m_pendMinProcUnits;
    }

    public void setPendMinProcUnits(UnsignedInt32 unsignedInt32) {
        this.m_pendMinProcUnits = unsignedInt32;
    }

    public UnsignedInt32 getPendAllocProcUnits() {
        return this.m_pendAllocProcUnits;
    }

    public void setPendAllocProcUnits(UnsignedInt32 unsignedInt32) {
        this.m_pendAllocProcUnits = unsignedInt32;
    }

    public UnsignedInt32 getPendMaxProcUnits() {
        return this.m_pendMaxProcUnits;
    }

    public void setPendMaxProcUnits(UnsignedInt32 unsignedInt32) {
        this.m_pendMaxProcUnits = unsignedInt32;
    }

    public UnsignedInt8 getRuntimeProcType() {
        return this.m_runtimeProcType;
    }

    public void setRuntimeProcType(UnsignedInt8 unsignedInt8) {
        this.m_runtimeProcType = unsignedInt8;
    }

    public UnsignedInt8 getRuntimeSharingMode() {
        return this.m_runtimeSharingMode;
    }

    public void setRuntimeSharingMode(UnsignedInt8 unsignedInt8) {
        this.m_runtimeSharingMode = unsignedInt8;
    }

    public UnsignedInt16 getRuntimeUncappedWeight() {
        return this.m_runtimeUncappedWeight;
    }

    public void setRuntimeUncappedWeight(UnsignedInt16 unsignedInt16) {
        this.m_runtimeUncappedWeight = unsignedInt16;
    }

    public UnsignedInt16 getRuntimeProcs() {
        return this.m_runtimeProcs;
    }

    public void setRuntimeProcs(UnsignedInt16 unsignedInt16) {
        this.m_runtimeProcs = unsignedInt16;
    }

    public UnsignedInt32 getRuntimeProcUnits() {
        return this.m_runtimeProcUnits;
    }

    public void setRuntimeProcUnits(UnsignedInt32 unsignedInt32) {
        this.m_runtimeProcUnits = unsignedInt32;
    }

    public UnsignedInt32 getCurMinMem() {
        return this.m_curMinMem;
    }

    public UnsignedInt32 getCurAllocMem() {
        return this.m_curAllocMem;
    }

    public UnsignedInt32 getCurMaxMem() {
        return this.m_curMaxMem;
    }

    public UnsignedInt32 getPendMinMem() {
        return this.m_pendMinMem;
    }

    public void setPendMinMem(UnsignedInt32 unsignedInt32) {
        this.m_pendMinMem = unsignedInt32;
    }

    public UnsignedInt32 getPendAllocMem() {
        return this.m_pendAllocMem;
    }

    public void setPendAllocMem(UnsignedInt32 unsignedInt32) {
        this.m_pendAllocMem = unsignedInt32;
    }

    public UnsignedInt32 getPendMaxMem() {
        return this.m_pendMaxMem;
    }

    public void setPendMaxMem(UnsignedInt32 unsignedInt32) {
        this.m_pendMaxMem = unsignedInt32;
    }

    public UnsignedInt32 getRuntimeMem() {
        return this.m_runtimeMem;
    }

    public void setRuntimeMem(UnsignedInt32 unsignedInt32) {
        this.m_runtimeMem = unsignedInt32;
    }

    public UnsignedInt32 getRuntimeMinMem() {
        return this.m_runtimeMinMem;
    }

    public UnsignedInt32 getReqMinForMax() {
        return this.m_reqMinForMax;
    }

    public UnsignedInt16 getCurMinIntPerf() {
        return this.m_curMinIntPerf;
    }

    public UnsignedInt16 getCurAllocIntPerf() {
        return this.m_curAllocIntPerf;
    }

    public UnsignedInt16 getCurMaxIntPerf() {
        return this.m_curMaxIntPerf;
    }

    public UnsignedInt16 getPendMinIntPerf() {
        return this.m_pendMinIntPerf;
    }

    public void setPendMinIntPerf(UnsignedInt16 unsignedInt16) {
        this.m_pendMinIntPerf = unsignedInt16;
    }

    public UnsignedInt16 getPendAllocIntPerf() {
        return this.m_pendAllocIntPerf;
    }

    public void setPendAllocIntPerf(UnsignedInt16 unsignedInt16) {
        this.m_pendAllocIntPerf = unsignedInt16;
    }

    public UnsignedInt16 getPendMaxIntPerf() {
        return this.m_pendMaxIntPerf;
    }

    public void setPendMaxIntPerf(UnsignedInt16 unsignedInt16) {
        this.m_pendMaxIntPerf = unsignedInt16;
    }

    public UnsignedInt16 getRuntimeIntPerf() {
        return this.m_runtimeIntPerf;
    }

    public void setRuntimeIntPerf(UnsignedInt16 unsignedInt16) {
        this.m_runtimeIntPerf = unsignedInt16;
    }

    public UnsignedInt16 getValidIntPerfMin() {
        return this.m_validIntPerfMin;
    }

    public UnsignedInt16 getValidIntPerfMax() {
        return this.m_validIntPerfMax;
    }

    public UnsignedInt8 getVirtualOptiConnect() {
        return this.m_virtualOptiConnect;
    }

    public void setVirtualOptiConnect(UnsignedInt8 unsignedInt8) {
        this.m_virtualOptiConnect = unsignedInt8;
    }

    public UnsignedInt8 getHSLOptiConnect() {
        return this.m_hslOptiConnect;
    }

    public void setHSLOptiConnect(UnsignedInt8 unsignedInt8) {
        this.m_hslOptiConnect = unsignedInt8;
    }

    public UnsignedInt32 getLoadSourceDRCIndex() {
        return this.m_loadSourceDRCIndex;
    }

    public void setLoadSourceDRCIndex(UnsignedInt32 unsignedInt32) {
        this.m_loadSourceDRCIndex = unsignedInt32;
    }

    public UnsignedInt32 getAltLoadSourceDRCIndex() {
        return this.m_altLoadSourceDRCIndex;
    }

    public void setAltLoadSourceDRCIndex(UnsignedInt32 unsignedInt32) {
        this.m_altLoadSourceDRCIndex = unsignedInt32;
    }

    public UnsignedInt32 getOldAltLoadSourceDRCIndex() {
        return this.m_oldAltLoadSourceDRCIndex;
    }

    public UnsignedInt32 getConsoleDRCIndex() {
        return this.m_consoleDRCIndex;
    }

    public void setConsoleDRCIndex(UnsignedInt32 unsignedInt32) {
        this.m_consoleDRCIndex = unsignedInt32;
    }

    public UnsignedInt32 getAltConsoleDRCIndex() {
        return this.m_altConsoleDRCIndex;
    }

    public void setAltConsoleDRCIndex(UnsignedInt32 unsignedInt32) {
        this.m_altConsoleDRCIndex = unsignedInt32;
    }

    public UnsignedInt32 getECSDRCIndex() {
        return this.m_ecsDRCIndex;
    }

    public void setECSDRCIndex(UnsignedInt32 unsignedInt32) {
        this.m_ecsDRCIndex = unsignedInt32;
    }

    public Boolean[] getTaggedIOInfo() {
        return this.m_taggedIOInfo;
    }

    public void setTaggedIOInfo(Boolean[] booleanArray) {
        this.m_taggedIOInfo = booleanArray;
    }

    public UnsignedInt8 getVirtualServiceLED() {
        return this.m_virtualServiceLed;
    }

    public UnsignedInt16 getCurMaxVirtualIO() {
        return this.m_curMaxVirtualIO;
    }

    public UnsignedInt16 getPendMaxVirtualIO() {
        return this.m_pendMaxVirtualIO;
    }

    public void setPendMaxVirtualIO(UnsignedInt16 unsignedInt16) {
        this.m_pendMaxVirtualIO = unsignedInt16;
    }

    public Hashtable getIoInfo() {
        return this.m_ioInfo;
    }

    public Hashtable getSMAInfo() {
        return this.m_smaInfo;
    }

    public Boolean getServiceAuthority() {
        return this.m_serviceAuthority;
    }

    public String toString(String[] stringArray, boolean bl, String string) {
        CSVRecord cSVRecord = new CSVRecord(true, string);
        for (int i = 0; i < stringArray.length; ++i) {
            int n;
            Object object;
            String string2 = stringArray[i];
            if (PARTITION_ID.equals(string2)) {
                object = null;
                object = this.m_internalName == null ? "null" : this.getLparID().toString();
                CSVRecord.append(cSVRecord, string2, (String)object, bl);
                continue;
            }
            if (USER_DEFINED_NAME.equals(string2) || NAME.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_userDefinedName, bl);
                continue;
            }
            if (PARTITION_TYPE.equals(string2) || PARTITION_TYPE_PROP.equals(string2) || PARTITION_ENVIRONMENT.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PILPARDataBean.getLparTypeString(this.m_definitionState), bl);
                continue;
            }
            if (DEFINITION_STATE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PILPARDataBean.getDefStateString(this.m_definitionState), bl);
                continue;
            }
            if (CLUSTER_ID.equals(string2)) {
                if (this.m_clusterID == null || this.m_clusterID.intValue() == 65535) {
                    CSVRecord.append(cSVRecord, string2, STRING_NO_CLUSTER, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (Number)this.m_clusterID, bl);
                continue;
            }
            if (SHARED_POOL_UTILIZATION_AUTHORITY.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_sharedPoolUtilizationAuthority, bl);
                continue;
            }
            if (HOSTING_PARTITIONS.equals(string2)) {
                if (this.m_hostingPartitions == null || this.m_hostingPartitions.length <= 0) {
                    CSVRecord.append(cSVRecord, string2, STRING_NO_CLUSTER, bl);
                    continue;
                }
                object = new CSVRecord(true, ",");
                for (n = 0; n < this.m_hostingPartitions.length; ++n) {
                    ((CSVRecord)object).add(this.m_hostingPartitions[n]);
                }
                CSVRecord.append(cSVRecord, string2, ((CSVRecord)object).toString(), bl);
                continue;
            }
            if (LOGICAL_SERIAL.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_logicalSerial, bl);
                continue;
            }
            if (OS_VERSION.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_OSVersion, bl);
                continue;
            }
            if (FUNCTIONAL_CONFIG.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_functionalConfig, bl);
                continue;
            }
            if (STATE.equals(string2) || PARTITION_STATE_PROP.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.getStateString(this.m_partitionState), bl);
                continue;
            }
            if (BOOT_MODE.equals(string2)) {
                if (bl && !this.isRPA()) continue;
                CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getBootModeString(this.m_partitionBootMode, this.isOS400()), bl);
                continue;
            }
            if (OP_PANEL_WIN_COUNT.equals(string2) || OP_PANEL_WIN_COUNT_PROP.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_opPanelWinCount, bl);
                continue;
            }
            if (DLPAR_CAPABILITIES.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_dlparCapabilities, bl);
                continue;
            }
            if ("cimObjectPath_PROP".equals(string2)) {
                if (this.m_cimObjPath == null) {
                    CSVRecord.append(cSVRecord, string2, "null", bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, this.m_cimObjPath.toString(), bl);
                continue;
            }
            if (IPL_SOURCE.equals(string2)) {
                if (bl && !this.isOS400()) continue;
                CSVRecord.append(cSVRecord, string2, PILPARDataBean.getIplSourceString(this.m_iplSource, this.isOS400()), bl);
                continue;
            }
            if (POWER_ON_WITH_HYP.equals(string2)) {
                if (this.m_powerWithHyp != null) {
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_powerWithHyp, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "unavailable", bl);
                continue;
            }
            if (TCP_INFO.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_tcpIpInfo, bl);
                continue;
            }
            if (SERVICE_AUTHORITY.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, this.m_serviceAuthority, bl);
                continue;
            }
            if (ACTIVE_PROFILE.equals(string2) || ACTIVE_PROFILE_PROP.equals(string2)) {
                if (this.m_activeProfile == "" || this.m_activeProfile == null) {
                    CSVRecord.append(cSVRecord, string2, STRING_NO_CLUSTER, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, this.m_activeProfile, bl);
                continue;
            }
            if (DEFAULT_PROFILE.equals(string2)) {
                if (this.m_defaultProfile == "" || this.m_defaultProfile == null) {
                    CSVRecord.append(cSVRecord, string2, STRING_NO_CLUSTER, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, this.m_defaultProfile, bl);
                continue;
            }
            if (CUR_SHARED_POOL_ID.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                if (this.m_curProcType != null && this.m_curProcType.shortValue() != 255) {
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_curProcType, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (CUR_PROC_TYPE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getProcTypeString(this.m_curProcType), bl);
                continue;
            }
            if (CUR_SHARING_MODE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getSharingModeString(this.m_curSharingMode, this.m_curProcType), bl);
                continue;
            }
            if (CUR_UNCAPPED_WEIGHT.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curUncappedWeight, bl);
                continue;
            }
            if (CUR_MIN_PROCS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curMinProcs, bl);
                continue;
            }
            if (CUR_ALLOC_PROCS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curAllocProcs, bl);
                continue;
            }
            if (CUR_MAX_PROCS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curMaxProcs, bl);
                continue;
            }
            if (CUR_MIN_PROC_UNITS.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_curMinProcUnits), bl);
                continue;
            }
            if (CUR_ALLOC_PROC_UNITS.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_curAllocProcUnits), bl);
                continue;
            }
            if (CUR_MAX_PROC_UNITS.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_curMaxProcUnits), bl);
                continue;
            }
            if (PEND_SHARED_POOL_ID.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                if (this.m_pendProcType != null && this.m_pendProcType.shortValue() != 255) {
                    CSVRecord.append(cSVRecord, string2, (Number)this.m_pendProcType, bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (PEND_PROC_TYPE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getProcTypeString(this.m_pendProcType), bl);
                continue;
            }
            if (PEND_SHARING_MODE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getSharingModeString(this.m_pendSharingMode, this.m_curProcType), bl);
                continue;
            }
            if (PEND_UNCAPPED_WEIGHT.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendUncappedWeight, bl);
                continue;
            }
            if (PEND_MIN_PROCS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendMinProcs, bl);
                continue;
            }
            if (PEND_ALLOC_PROCS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendAllocProcs, bl);
                continue;
            }
            if (PEND_MAX_PROCS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendMaxProcs, bl);
                continue;
            }
            if (PEND_MIN_PROC_UNITS.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_pendMinProcUnits), bl);
                continue;
            }
            if (PEND_ALLOC_PROC_UNITS.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_pendAllocProcUnits), bl);
                continue;
            }
            if (PEND_MAX_PROC_UNITS.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_pendMaxProcUnits), bl);
                continue;
            }
            if (RUNTIME_PROC_TYPE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getProcTypeString(this.m_runtimeProcType), bl);
                continue;
            }
            if (RUNTIME_SHARING_MODE.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, PILPARProfileDataBean.getSharingModeString(this.m_runtimeSharingMode, this.m_curProcType), bl);
                continue;
            }
            if (RUNTIME_UNCAPPED_WEIGHT.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeUncappedWeight, bl);
                continue;
            }
            if (RUNTIME_PROCS.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeProcs, bl);
                continue;
            }
            if (RUNTIME_PROC_UNITS.equals(string2)) {
                if (bl && this.m_curProcType != null && !this.isProcModeShared()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_runtimeProcUnits), bl);
                continue;
            }
            if (CUR_MIN_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curMinMem, bl);
                continue;
            }
            if (CUR_ALLOC_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curAllocMem, bl);
                continue;
            }
            if (CUR_MAX_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curMaxMem, bl);
                continue;
            }
            if (PEND_MIN_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendMinMem, bl);
                continue;
            }
            if (PEND_ALLOC_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendAllocMem, bl);
                continue;
            }
            if (PEND_MAX_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendMaxMem, bl);
                continue;
            }
            if (RUNTIME_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeMem, bl);
                continue;
            }
            if (RUNTIME_MIN_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeMinMem, bl);
                continue;
            }
            if (REQ_MIN_MAX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeMinMem, bl);
                continue;
            }
            if (MM_CURR_RESERVE1_MAX_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmCurrReserve1MaxMem, bl);
                continue;
            }
            if (MM_CURR_RESERVE1_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmCurrReserve1Mem, bl);
                continue;
            }
            if (MM_CURR_RESERVE1_MIN_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmCurrReserve1MinMem, bl);
                continue;
            }
            if (MM_PEND_RESERVE1_MAX_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmPendReserve1MaxMem, bl);
                continue;
            }
            if (MM_PEND_RESERVE1_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmPendReserve1Mem, bl);
                continue;
            }
            if (MM_PEND_RESERVE1_MIN_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmPendReserve1MinMem, bl);
                continue;
            }
            if (MM_CURR_RESERVE2_MAX_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmCurrReserve2MaxMem, bl);
                continue;
            }
            if (MM_CURR_RESERVE2_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmCurrReserve2Mem, bl);
                continue;
            }
            if (MM_CURR_RESERVE2_MIN_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmCurrReserve2MinMem, bl);
                continue;
            }
            if (MM_PEND_RESERVE2_MAX_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmPendReserve2MaxMem, bl);
                continue;
            }
            if (MM_PEND_RESERVE2_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmPendReserve2Mem, bl);
                continue;
            }
            if (MM_PEND_RESERVE2_MIN_MEM.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_mmPendReserve2MinMem, bl);
                continue;
            }
            if (CUR_MIN_INT_PERF.equals(string2)) {
                if (bl && this.m_definitionState != null && !this.isOS400()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_curMinIntPerf), bl);
                continue;
            }
            if (CUR_ALLOC_INT_PERF.equals(string2)) {
                if (bl && this.m_definitionState != null && !this.isOS400()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_curAllocIntPerf), bl);
                continue;
            }
            if (CUR_MAX_INT_PERF.equals(string2)) {
                if (bl && this.m_definitionState != null && !this.isOS400()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_curMaxIntPerf), bl);
                continue;
            }
            if (PEND_MIN_INT_PERF.equals(string2)) {
                if (bl && this.m_definitionState != null && !this.isOS400()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_pendMinIntPerf), bl);
                continue;
            }
            if (PEND_ALLOC_INT_PERF.equals(string2)) {
                if (bl && this.m_definitionState != null && !this.isOS400()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_pendAllocIntPerf), bl);
                continue;
            }
            if (PEND_MAX_INT_PERF.equals(string2)) {
                if (bl && this.m_definitionState != null && !this.isOS400()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_pendMaxIntPerf), bl);
                continue;
            }
            if (RUNTIME_INT_PERF.equals(string2)) {
                if (bl && this.m_definitionState != null && !this.isOS400()) continue;
                CSVRecord.append(cSVRecord, string2, PIHMCCommandUtils.convertIntToFloatString(this.m_runtimeIntPerf), bl);
                continue;
            }
            if (VALID_INT_PERF_MIN.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeIntPerf, bl);
                continue;
            }
            if (VALID_INT_PERF_MAX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_runtimeIntPerf, bl);
                continue;
            }
            if (VIRTUAL_OPTICONNECT.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_virtualOptiConnect, bl);
                continue;
            }
            if (HSL_OPTICONNECT.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_hslOptiConnect, bl);
                continue;
            }
            if (LOADSOURCE_INDEX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_loadSourceDRCIndex, bl);
                continue;
            }
            if (ALT_LOADSOURCE_INDEX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_altLoadSourceDRCIndex, bl);
                continue;
            }
            if (OLD_ALT_LOADSOURCE_INDEX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_oldAltLoadSourceDRCIndex, bl);
                continue;
            }
            if (CONSOLE_INDEX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_consoleDRCIndex, bl);
                continue;
            }
            if (ALT_CONSOLE_INDEX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_altConsoleDRCIndex, bl);
                continue;
            }
            if (ECS_INDEX.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_ecsDRCIndex, bl);
                continue;
            }
            if (TAGGED_IO_INFO.equals(string2)) {
                if (this.m_taggedIOInfo != null && this.m_taggedIOInfo.length != 0) {
                    object = new CSVRecord(true, ",");
                    for (n = 0; n < this.m_taggedIOInfo.length; ++n) {
                        ((CSVRecord)object).add(this.m_taggedIOInfo[n]);
                    }
                    CSVRecord.append(cSVRecord, string2, ((CSVRecord)object).toString(), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, (String)null, bl);
                continue;
            }
            if (IO_INFO.equals(string2) || IO_INFO_PROP.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_ecsDRCIndex, bl);
                continue;
            }
            if (SMA_INFO.equals(string2) || SMA_INFO_PROP.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_ecsDRCIndex, bl);
                continue;
            }
            if (VIRTUAL_SERVICE_LED.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_ecsDRCIndex, bl);
                continue;
            }
            if (CUR_MAX_VIRTUAL_IO.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_curMaxVirtualIO, bl);
                continue;
            }
            if (PEND_MAX_VIRTUAL_IO.equals(string2)) {
                CSVRecord.append(cSVRecord, string2, (Number)this.m_pendMaxVirtualIO, bl);
                continue;
            }
            if (SRC.equals(string2)) {
                if (this.m_src != null) {
                    CSVRecord.append(cSVRecord, string2, this.m_src.toString(), bl);
                    continue;
                }
                CSVRecord.append(cSVRecord, string2, "", bl);
                continue;
            }
            if (!LPAR_KEYLOCK.equals(string2)) continue;
            if (this.m_lparKeylock != null) {
                CSVRecord.append(cSVRecord, string2, this.getKeylockString(this.m_lparKeylock), bl);
                continue;
            }
            CSVRecord.append(cSVRecord, string2, "unavailable", bl);
        }
        return cSVRecord.toString();
    }

    public String toString() {
        return "[" + this.toString(ALL_KEYS, true, ",") + "]";
    }

    private String getStateString(UnsignedInt8 unsignedInt8) {
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        String string = PIHscUtil.getLparStateString(unsignedInt8);
        Locale.setDefault(locale);
        return string;
    }

    private String getKeylockString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8 != null) {
            if (unsignedInt8.intValue() == 2) {
                return "manual";
            }
            if (unsignedInt8.intValue() == 4) {
                return "norm";
            }
            return unsignedInt8.toString();
        }
        return "Unknown";
    }

    public static String getIplSourceString(UnsignedInt8 unsignedInt8, boolean bl) {
        if (bl) {
            if (unsignedInt8 != null) {
                short s = unsignedInt8.shortValue();
                if (s == 8) {
                    return "a";
                }
                if (s == 9) {
                    return "b";
                }
                if (s == 10) {
                    return "c";
                }
                if (s == 11) {
                    return "d";
                }
                return unsignedInt8.toString();
            }
            return "unavailable";
        }
        return null;
    }

    public static String getDefStateString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8 != null) {
            short s = unsignedInt8.shortValue();
            if (s == 2 || s == 66 || s == 130) {
                return "1";
            }
            if (s == 1 || s == 65 || s == 129) {
                return "0";
            }
            return unsignedInt8.toString();
        }
        return null;
    }

    public static String getLparTypeString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8 != null) {
            short s = unsignedInt8.shortValue();
            if (s == 2 || s == 1) {
                return STRING_RPA;
            }
            if (s == 130 || s == 129) {
                return STRING_OS400;
            }
            if (s == 66 || s == 65) {
                return STRING_MM_RPA;
            }
            if (s == 4 || s == 3) {
                return STRING_VIOSERVER;
            }
            return unsignedInt8.toString();
        }
        return null;
    }

    public static String getLparTypeBundleString(UnsignedInt8 unsignedInt8) {
        if (unsignedInt8 != null) {
            short s = unsignedInt8.shortValue();
            if (s == 2 || s == 1) {
                return HSCResourceBundleUtil.getMessage("ProfileBundle", "OSTYPE_AIX_LINUX");
            }
            if (s == 130 || s == 129) {
                return HSCResourceBundleUtil.getMessage("ProfileBundle", "OSTYPE_OS400");
            }
            if (s == 66 || s == 65) {
                return HSCResourceBundleUtil.getMessage("PIHscCommonBundle", "SHARK");
            }
            if (s == 4 || s == 3) {
                return HSCResourceBundleUtil.getMessage("ProfileBundle", "OSTYPE_RPA_IO_SERVER");
            }
            return unsignedInt8.toString();
        }
        return null;
    }

    public UnsignedInt32 getM_mmCurrReserve1MinMem() {
        return this.m_mmCurrReserve1MinMem;
    }

    public void setM_mmCurrReserve1MinMem(UnsignedInt32 unsignedInt32) {
        this.m_mmCurrReserve1MinMem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmCurrReserve1Mem() {
        return this.m_mmCurrReserve1Mem;
    }

    public void setM_mmCurrReserve1Mem(UnsignedInt32 unsignedInt32) {
        this.m_mmCurrReserve1Mem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmCurrReserve1MaxMem() {
        return this.m_mmCurrReserve1MaxMem;
    }

    public void setM_mmCurrReserve1MaxMem(UnsignedInt32 unsignedInt32) {
        this.m_mmCurrReserve1MaxMem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmPendReserve1MinMem() {
        return this.m_mmPendReserve1MinMem;
    }

    public void setM_mmPendReserve1MinMem(UnsignedInt32 unsignedInt32) {
        this.m_mmPendReserve1MinMem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmPendReserve1Mem() {
        return this.m_mmPendReserve1Mem;
    }

    public void setM_mmPendReserve1Mem(UnsignedInt32 unsignedInt32) {
        this.m_mmPendReserve1Mem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmPendReserve1MaxMem() {
        return this.m_mmPendReserve1MaxMem;
    }

    public void setM_mmPendReserve1MaxMem(UnsignedInt32 unsignedInt32) {
        this.m_mmPendReserve1MaxMem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmCurrReserve2MinMem() {
        return this.m_mmCurrReserve2MinMem;
    }

    public void setM_mmCurrReserve2MinMem(UnsignedInt32 unsignedInt32) {
        this.m_mmCurrReserve2MinMem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmCurrReserve2Mem() {
        return this.m_mmCurrReserve2Mem;
    }

    public void setM_mmCurrReserve2Mem(UnsignedInt32 unsignedInt32) {
        this.m_mmCurrReserve2Mem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmCurrReserve2MaxMem() {
        return this.m_mmCurrReserve2MaxMem;
    }

    public void setM_mmCurrReserve2MaxMem(UnsignedInt32 unsignedInt32) {
        this.m_mmCurrReserve2MaxMem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmPendReserve2MinMem() {
        return this.m_mmPendReserve2MinMem;
    }

    public void setM_mmPendReserve2MinMem(UnsignedInt32 unsignedInt32) {
        this.m_mmPendReserve2MinMem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmPendReserve2Mem() {
        return this.m_mmPendReserve2Mem;
    }

    public void setM_mmPendReserve2Mem(UnsignedInt32 unsignedInt32) {
        this.m_mmPendReserve2Mem = unsignedInt32;
    }

    public UnsignedInt32 getM_mmPendReserve2MaxMem() {
        return this.m_mmPendReserve2MaxMem;
    }

    public void setM_mmPendReserve2MaxMem(UnsignedInt32 unsignedInt32) {
        this.m_mmPendReserve2MaxMem = unsignedInt32;
    }

    public UnsignedInt8[] getM_suppVirtualpanelFuncs() {
        return this.m_suppVirtualpanelFuncs;
    }

    public void setM_suppVirtualpanelFuncs(UnsignedInt8[] unsignedInt8Array) {
        this.m_suppVirtualpanelFuncs = unsignedInt8Array;
    }

    public UnsignedInt32 getSysCmdCapabilities() {
        return this.m_sysCmdCapabilities;
    }
}

